//Verificatioin of  Wiener-Khnichine relation for the signal x(t)=sin(30.pi.t)+sin(60.pi.t)
// Autocorrelation function and Power spectral Density of a signal form a Fourier transform pair
//Windows 10
//Scilab 6.1.0
clear
clc
fs=input('Enter the sampling Frequency:')
T=input('Enter the duration upto which the signal is to be plotted:')
t=0:1/fs:T;
x=sin(30*%pi*t)+sin(60*%pi*t);
N=input('Enter the DFT length:')
//making the length of x equal to N
if length(x)<N
    x(length(x)+1:N)=0;
else
   if length(x)>N
    x(N+1:length(x))=[]; 
end
end
//computation of N point DFT of the sequence
X=fft(x);
f=fs*(0:N-1)/N;
//computation of PSD = (1/N)*abs(fft)^2 using the direct expression
PS=(1/N)*(abs(X).^2);
//computation of Autocorrelation function of the signal
R=xcorr(x,x);
//making length of R equal to N
if  length(R)<N
    R(length(R)+1:N)=0;
else
    if length(R)>N
    R(N+1:length(R))=[];
end
end
//computation of Power Spectral Density drom Autocorrelation Function
PSD=fft(R);
subplot(2,1,1)
xset("thickness",3)
plot2d3(f,PS)
xtitle("Power spectral density computed",'freuqency','Watts/Hz')
mtlb_axis([min(f) max(f) min(PS) max(PS)])
legend("PSD=(1/N).|X(k)|^2")
subplot(2,1,2)
xset("thickness",3)
plot2d3(f,abs(PSD))
xtitle("Power spectral density computed from Autocorrelation Function",'freuqency','Watts/Hz')
mtlb_axis([min(f) max(f) min(abs(PSD)) max(abs(PSD))])
legend("PSD=Fourier Transform of Autocorrelation Function")
//sampling Frequency:  100
//duration upto which the signsal is to be plotted:  10
//DFT length:  1024
 
